/* error_geometric_series.c
積み残し現象
r = 0.999 のとき、等比級数の和
  1 + r + r^2 + ... 
の理論値は 1 / (1 - r) = 1000 だが ...
*/

#include<stdio.h>
#include<math.h>
int main(){
    double r = 0.999, x;
    printf("昇順に加えると\n");
    for(int j = 4; j <= 7; j++){
        long n = (long)pow(10, j);
        x = 0.0;
        for(long i = 0; i <= n; i++) x += pow(r, i);
        printf("10^%d項目までの和 = %17.12lf\n", j, x);
    }
    printf("\n");
    printf("降順に加えるとちょっとましで\n");
    for(int j = 4; j <= 7; j++){
        long n = (long)pow(10, j);
        x = 1.0;
        for(long i = n; i >= 0; i--) x += pow(r, i);
        printf("10^%d項目までの和 = %17.12lf\n", j, x);
    }
    return 0;
}

/*

昇順に加えると
10^4項目までの和 =  999.954871827366
10^5項目までの和 =  999.999999999951
10^6項目までの和 =  999.999999999951
10^7項目までの和 =  999.999999999951

降順に加えるとちょっとましで
10^4項目までの和 =  999.954871827368
10^5項目までの和 =  999.999999999999
10^6項目までの和 =  999.999999999999
10^7項目までの和 =  999.999999999999

*/
